﻿using UnityEngine;
using System.Collections;
using DigitalRuby.ThunderAndLightning;

public class Player : MonoBehaviour {
    public UH unlimitedhand;

    public SteamVR_TrackedController leftController;
    public SteamVR_TrackedController rightController;

    private bool isLeftTriggerDown;
    private bool isRightTriggerDown;

    public LightningBoltPrefabScriptBase chargedLightning;
    public LightningBoltPrefabScriptBase taserFarLightning;
    public LightningBoltPrefabScriptBase taserNearLightning;

    public Transform taserTransform;
    public Transform armTransform;

    public AudioSource taserSound;

    private float lastSparkTime = float.MinValue;
    public float sparkCoolTime = 5.0f;

    public float sparkDistance = 0.2f;
    public AudioSource chargedSound;

    private float energy = 0;

    // Use this for initialization
    void Start () {
        leftController.TriggerClicked += LeftTriggerClicked;
        leftController.TriggerUnclicked += LeftTriggerUnclicked;
        rightController.TriggerClicked += RightTriggerClicked;
        rightController.TriggerUnclicked += RightTriggerUnclicked;

        chargedLightning.gameObject.SetActive(false);
        taserFarLightning.gameObject.SetActive(true);
        taserNearLightning.gameObject.SetActive(true);

        StartCoroutine(Sparking(0.25f));
    }
	
	// Update is called once per frame
	void Update () {
    }

    void RightTriggerClicked(object sender, ClickedEventArgs e)
    {
        Debug.Log("RightTriggerClicked");

        isRightTriggerDown = true;
    }

    void RightTriggerUnclicked(object sender, ClickedEventArgs e)
    {
        Debug.Log("RightTriggerUnclicked");

        isRightTriggerDown = false;
    }
    void LeftTriggerClicked(object sender, ClickedEventArgs e)
    {
        Debug.Log("LeftTriggerClicked");

        taserSound.volume = 0.5f;

        if (Time.time > lastSparkTime + sparkCoolTime)
        {

            float distance = (taserTransform.position - armTransform.position).magnitude;
            if (distance < sparkDistance)
            {
                // チャージ.
                int num = Random.Range(0, 7);
                unlimitedhand.stimulate(num);

                energy += 1.0f;
                if (energy >= 5.0f) {
                    chargedSound.Play();
                    chargedLightning.gameObject.SetActive(true);
                }

                lastSparkTime = Time.time;
            }
            else
            {
                // 空振り.
                Debug.Log("Miss...");
            }
        }
        else {
            // 連打防止.
            Debug.Log("Charging ... ");
        }

        isRightTriggerDown = true;
    }

    void LeftTriggerUnclicked(object sender, ClickedEventArgs e)
    {
        Debug.Log("LeftTriggerUnclicked");

        taserSound.volume = 0.0f;

        isRightTriggerDown = false;
    }

    IEnumerator Sparking (float interval)
    {
        while (true)
        {
            if (isRightTriggerDown)
            {
                float distance = (taserTransform.position - armTransform.position).magnitude;
                Debug.Log("distance is " + distance);


                if (distance < sparkDistance)
                {
                    // チャージ.
                    int num = Random.Range(0, 7);
                    unlimitedhand.stimulate(num);

                    taserNearLightning.Trigger();

                    lastSparkTime = Time.time;
                }
                else
                {
                    taserFarLightning.Trigger();
                }
            }
            yield return new WaitForSeconds(interval);
        }
    }
}
