// Shader created with Shader Forge v1.26 
// Shader Forge (c) Neat Corporation / Joachim Holmer - http://www.acegikmo.com/shaderforge/
// Note: Manually altering this data may prevent you from opening it in Shader Forge
/*SF_DATA;ver:1.26;sub:START;pass:START;ps:flbk:,iptp:0,cusa:False,bamd:0,lico:1,lgpr:1,limd:0,spmd:1,trmd:0,grmd:0,uamb:True,mssp:True,bkdf:False,hqlp:False,rprd:False,enco:False,rmgx:True,rpth:0,vtps:0,hqsc:True,nrmq:1,nrsp:0,vomd:0,spxs:False,tesm:0,olmd:1,culm:0,bsrc:3,bdst:7,dpts:2,wrdp:False,dith:0,rfrpo:True,rfrpn:Refraction,coma:15,ufog:True,aust:False,igpj:True,qofs:0,qpre:3,rntp:2,fgom:False,fgoc:True,fgod:False,fgor:False,fgmd:0,fgcr:0,fgcg:0,fgcb:0,fgca:1,fgde:0.01,fgrn:0,fgrf:300,stcl:False,stva:128,stmr:255,stmw:255,stcp:6,stps:0,stfa:0,stfz:0,ofsf:0,ofsu:0,f2p0:False,fnsp:True,fnfb:True;n:type:ShaderForge.SFN_Final,id:4795,x:32724,y:32693,varname:node_4795,prsc:2|emission-797-RGB,alpha-6648-OUT,voffset-6674-OUT,tess-3995-OUT;n:type:ShaderForge.SFN_Color,id:797,x:32164,y:32796,ptovrint:True,ptlb:Color,ptin:_TintColor,varname:_TintColor,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,c1:1,c2:1,c3:1,c4:0.2509804;n:type:ShaderForge.SFN_NormalVector,id:3672,x:32001,y:33216,prsc:2,pt:False;n:type:ShaderForge.SFN_ViewVector,id:8073,x:32001,y:33369,varname:node_8073,prsc:2;n:type:ShaderForge.SFN_Dot,id:1311,x:32440,y:33214,varname:node_1311,prsc:2,dt:3|A-3672-OUT,B-3025-OUT;n:type:ShaderForge.SFN_Normalize,id:3025,x:32211,y:33294,varname:node_3025,prsc:2|IN-8073-OUT;n:type:ShaderForge.SFN_OneMinus,id:3263,x:32531,y:33069,varname:node_3263,prsc:2|IN-1311-OUT;n:type:ShaderForge.SFN_Time,id:1580,x:31779,y:33843,varname:node_1580,prsc:2;n:type:ShaderForge.SFN_Slider,id:914,x:31923,y:33562,ptovrint:False,ptlb:Aura Intensity,ptin:_AuraIntensity,varname:node_914,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,min:0,cur:0.02,max:1;n:type:ShaderForge.SFN_Multiply,id:6674,x:32418,y:33396,varname:node_6674,prsc:2|A-3672-OUT,B-914-OUT,C-6826-OUT;n:type:ShaderForge.SFN_Tex2d,id:4821,x:32407,y:33723,ptovrint:False,ptlb:node_4821,ptin:_node_4821,varname:node_4821,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,tex:28c7aad1372ff114b90d330f8a2dd938,ntxv:1,isnm:False|UVIN-450-UVOUT;n:type:ShaderForge.SFN_Panner,id:450,x:32212,y:33772,varname:node_450,prsc:2,spu:0,spv:-1|UVIN-6870-OUT,DIST-4481-OUT;n:type:ShaderForge.SFN_Multiply,id:6648,x:32480,y:32934,varname:node_6648,prsc:2|A-797-A,B-3263-OUT;n:type:ShaderForge.SFN_Slider,id:3995,x:32630,y:33238,ptovrint:False,ptlb:Tesselation,ptin:_Tesselation,varname:node_3995,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,min:0,cur:10,max:10;n:type:ShaderForge.SFN_Dot,id:4737,x:31829,y:33662,varname:node_4737,prsc:2,dt:0|A-1353-XYZ,B-6391-OUT;n:type:ShaderForge.SFN_Vector3,id:6391,x:31595,y:33795,varname:node_6391,prsc:2,v1:0,v2:1,v3:0;n:type:ShaderForge.SFN_ComponentMask,id:6870,x:32001,y:33662,varname:node_6870,prsc:2,cc1:0,cc2:0,cc3:-1,cc4:-1|IN-4737-OUT;n:type:ShaderForge.SFN_FragmentPosition,id:1353,x:31595,y:33606,varname:node_1353,prsc:2;n:type:ShaderForge.SFN_Slider,id:3407,x:31701,y:34007,ptovrint:False,ptlb:Aura Speed,ptin:_AuraSpeed,varname:node_3407,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,min:0,cur:0.5,max:1;n:type:ShaderForge.SFN_Multiply,id:4481,x:32017,y:33875,varname:node_4481,prsc:2|A-1580-T,B-3407-OUT;n:type:ShaderForge.SFN_Slider,id:7820,x:31739,y:33472,ptovrint:False,ptlb:Aura Offset,ptin:_AuraOffset,varname:node_7820,prsc:2,glob:False,taghide:False,taghdr:False,tagprd:False,tagnsco:False,tagnrm:False,min:0,cur:0.1,max:10;n:type:ShaderForge.SFN_Add,id:6826,x:32643,y:33541,varname:node_6826,prsc:2|A-7820-OUT,B-4821-R;proporder:797-914-4821-3995-3407-7820;pass:END;sub:END;*/

Shader "Shader Forge/Aura" {
    Properties {
        _TintColor ("Color", Color) = (1,1,1,0.2509804)
        _AuraIntensity ("Aura Intensity", Range(0, 1)) = 0.02
        _node_4821 ("node_4821", 2D) = "gray" {}
        _Tesselation ("Tesselation", Range(0, 10)) = 10
        _AuraSpeed ("Aura Speed", Range(0, 1)) = 0.5
        _AuraOffset ("Aura Offset", Range(0, 10)) = 0.1
        [HideInInspector]_Cutoff ("Alpha cutoff", Range(0,1)) = 0.5
    }
    SubShader {
        Tags {
            "IgnoreProjector"="True"
            "Queue"="Transparent"
            "RenderType"="Transparent"
        }
        Pass {
            Name "FORWARD"
            Tags {
                "LightMode"="ForwardBase"
            }
            Blend SrcAlpha OneMinusSrcAlpha
            ZWrite Off
            
            CGPROGRAM
            #pragma hull hull
            #pragma domain domain
            #pragma vertex tessvert
            #pragma fragment frag
            #define UNITY_PASS_FORWARDBASE
            #include "UnityCG.cginc"
            #include "Tessellation.cginc"
            #pragma multi_compile_fwdbase
            #pragma multi_compile_fog
            #pragma exclude_renderers gles3 metal d3d11_9x xbox360 xboxone ps3 ps4 psp2 
            #pragma target 5.0
            #pragma glsl
            uniform float4 _TimeEditor;
            uniform float4 _TintColor;
            uniform float _AuraIntensity;
            uniform sampler2D _node_4821; uniform float4 _node_4821_ST;
            uniform float _Tesselation;
            uniform float _AuraSpeed;
            uniform float _AuraOffset;
            struct VertexInput {
                float4 vertex : POSITION;
                float3 normal : NORMAL;
                float4 tangent : TANGENT;
            };
            struct VertexOutput {
                float4 pos : SV_POSITION;
                float4 posWorld : TEXCOORD0;
                float3 normalDir : TEXCOORD1;
                UNITY_FOG_COORDS(2)
            };
            VertexOutput vert (VertexInput v) {
                VertexOutput o = (VertexOutput)0;
                o.normalDir = UnityObjectToWorldNormal(v.normal);
                float4 node_1580 = _Time + _TimeEditor;
                float2 node_450 = (dot(mul(_Object2World, v.vertex).rgb,float3(0,1,0)).rr+(node_1580.g*_AuraSpeed)*float2(0,-1));
                float4 _node_4821_var = tex2Dlod(_node_4821,float4(TRANSFORM_TEX(node_450, _node_4821),0.0,0));
                v.vertex.xyz += (v.normal*_AuraIntensity*(_AuraOffset+_node_4821_var.r));
                o.posWorld = mul(_Object2World, v.vertex);
                o.pos = mul(UNITY_MATRIX_MVP, v.vertex );
                UNITY_TRANSFER_FOG(o,o.pos);
                return o;
            }
            #ifdef UNITY_CAN_COMPILE_TESSELLATION
                struct TessVertex {
                    float4 vertex : INTERNALTESSPOS;
                    float3 normal : NORMAL;
                    float4 tangent : TANGENT;
                };
                struct OutputPatchConstant {
                    float edge[3]         : SV_TessFactor;
                    float inside          : SV_InsideTessFactor;
                    float3 vTangent[4]    : TANGENT;
                    float2 vUV[4]         : TEXCOORD;
                    float3 vTanUCorner[4] : TANUCORNER;
                    float3 vTanVCorner[4] : TANVCORNER;
                    float4 vCWts          : TANWEIGHTS;
                };
                TessVertex tessvert (VertexInput v) {
                    TessVertex o;
                    o.vertex = v.vertex;
                    o.normal = v.normal;
                    o.tangent = v.tangent;
                    return o;
                }
                float Tessellation(TessVertex v){
                    return _Tesselation;
                }
                float4 Tessellation(TessVertex v, TessVertex v1, TessVertex v2){
                    float tv = Tessellation(v);
                    float tv1 = Tessellation(v1);
                    float tv2 = Tessellation(v2);
                    return float4( tv1+tv2, tv2+tv, tv+tv1, tv+tv1+tv2 ) / float4(2,2,2,3);
                }
                OutputPatchConstant hullconst (InputPatch<TessVertex,3> v) {
                    OutputPatchConstant o = (OutputPatchConstant)0;
                    float4 ts = Tessellation( v[0], v[1], v[2] );
                    o.edge[0] = ts.x;
                    o.edge[1] = ts.y;
                    o.edge[2] = ts.z;
                    o.inside = ts.w;
                    return o;
                }
                [domain("tri")]
                [partitioning("fractional_odd")]
                [outputtopology("triangle_cw")]
                [patchconstantfunc("hullconst")]
                [outputcontrolpoints(3)]
                TessVertex hull (InputPatch<TessVertex,3> v, uint id : SV_OutputControlPointID) {
                    return v[id];
                }
                [domain("tri")]
                VertexOutput domain (OutputPatchConstant tessFactors, const OutputPatch<TessVertex,3> vi, float3 bary : SV_DomainLocation) {
                    VertexInput v = (VertexInput)0;
                    v.vertex = vi[0].vertex*bary.x + vi[1].vertex*bary.y + vi[2].vertex*bary.z;
                    v.normal = vi[0].normal*bary.x + vi[1].normal*bary.y + vi[2].normal*bary.z;
                    v.tangent = vi[0].tangent*bary.x + vi[1].tangent*bary.y + vi[2].tangent*bary.z;
                    VertexOutput o = vert(v);
                    return o;
                }
            #endif
            float4 frag(VertexOutput i) : COLOR {
                i.normalDir = normalize(i.normalDir);
                float3 viewDirection = normalize(_WorldSpaceCameraPos.xyz - i.posWorld.xyz);
                float3 normalDirection = i.normalDir;
////// Lighting:
////// Emissive:
                float3 emissive = _TintColor.rgb;
                float3 finalColor = emissive;
                fixed4 finalRGBA = fixed4(finalColor,(_TintColor.a*(1.0 - abs(dot(i.normalDir,normalize(viewDirection))))));
                UNITY_APPLY_FOG_COLOR(i.fogCoord, finalRGBA, fixed4(0,0,0,1));
                return finalRGBA;
            }
            ENDCG
        }
    }
    CustomEditor "ShaderForgeMaterialInspector"
}
